//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit and Windows XP SP3, 32 bit
//Scilab version: 5.4.1 (Tested on both 32 bit and 64 bit versions)
//Program Title: Cyclic Codes (7,4)

clc;
clear;
k = 4; //Information Message Length
n = 7; //Codeword Length

//Generator Polynomial
x=poly(0,'x');
GenPoly=1+x+x^3;
disp(GenPoly,'The Generator Polynomial');

//Generating Random Message

//All_M = All 16 posibilities for Information Message Matrix
All_M = [0 0 0 0;0 0 0 1;0 0 1 0;0 0 1 1;
0 1 0 0;0 1 0 1;0 1 1 0;0 1 1 1;
1 0 0 0;1 0 0 1;1 0 1 0;1 0 1 1;
1 1 0 0;1 1 0 1;1 1 1 0;1 1 1 1]

RandMessage=modulo(round(16*rand()),16)+1//Get random number between 1 to 16

M=All_M(RandMessage,:)//Select a random row from Message Matrix All_M as Information Message
disp(M,'Information Message M')

//Message Polynomial
MesPoly=(M(1)*1) + (M(2)*(x^1)) + (M(3)*(x^2)) + (M(4)*(x^3));
disp(MesPoly,'Message Polynomial u(x)');

//Encoding------------------------------------------------------------------------------

//Generating Codeword Polynomial
p=(x^(n-k))*(MesPoly);//Step 1 - multiply MesPoly by x^(n-k), [x^(n-k)*u(x)]
[RemPoly,q]=pdiv(p,GenPoly);//Step 2 - divide above product by GenPoly, g(x)(Polynomial Division)
RemPoly=modulo(RemPoly,2);//Convert Remainder Polynomial to binary to get parity check polynomial, b(x)
disp(RemPoly,'Remainder Polynomial b(x)');
CodePoly=RemPoly+(MesPoly*(x^(n-k)));//Step 3 - add (x^(n-k)*u(x)) and b(x) to get Codeword Polynomial
disp(CodePoly,'Codeword Polynomial c(x)');

//Finding Coefficients of Codeword Polynomial
CodePolyCoeff=coeff(CodePoly);
    //Removal of - signs from Coefficients of Codeword Polynomial
    for i=1:length(CodePolyCoeff)
        if (CodePolyCoeff(i)==-1) then
            CodePolyCoeff(i)=1;
        end
    end
disp(CodePolyCoeff,'Coefficients of Codeword Polynomial');

//Generating 7 bit Codeword from Coefficients of Codeword Polynomial
C=CodePolyCoeff;
if length(C)<7 then
    C(1,7)=0;//Assigning a value outside arrey dimension will automatically 
            //pad additional zeros to resize the arrey / vector
end
disp(C,'Generated Codeword');

//Transmition--------------------------------------------------------------------------
R=C//Create recieved code word

    //Generate error at random bit position
    ErrPos=modulo(round(8*rand()),8)//Get random number between 0 to 7
    //ErrPos=0 //for testing
    if ErrPos==0 then
        //Do nothing, as '0' means no error
    else
        if R(ErrPos)==0 then
            R(ErrPos)=1//Invert bit at Erroneous Bit Position
        else
            R(ErrPos)=0//Invert bit at Erroneous Bit Position
        end
    end

//Reception and Decoding----------------------------------------------------------------------

disp(R,'Recieved Code word R')

//Received Polynomial
RecPoly=(R(1)*1) + (R(2)*(x^1)) + (R(3)*(x^2)) + (R(4)*(x^3)) + (R(5)*(x^4)) + (R(6)*(x^5)) + (R(7)*(x^6));
disp(RecPoly,'Received Polynomial u(x)');

//Syndrome Polynomial
[SynPoly,q]=pdiv(RecPoly,GenPoly);
SynPoly=modulo(SynPoly,2)
disp(SynPoly,'Syndrome Polynomial')

//Finding Coefficients of Syndrome Polynomial
SynPolyCoeff=coeff(SynPoly);
    //Removal of - signs from Coefficients of Syndrome Polynomial
    for i=1:length(SynPolyCoeff)
        if (SynPolyCoeff(i)==-1) then
            SynPolyCoeff(i)=1;
        end
    end
disp(SynPolyCoeff,'Coefficients of Syndrome Polynomial');

//Generating 3 bit Syndrome from Coefficients of Syndrome Polynomial
if length(SynPolyCoeff)<3 then
    SynPolyCoeff(1,3)=0;//Assigning a value outside arrey dimension will automatically 
            //pad additional zeros to resize the arrey / vector
end
disp(SynPolyCoeff,'Syndrome');



        //Create H (Parity check matrix) as error lookup table
        P = [1 1 0;0 1 1 ;1 1 1;1 0 1]//Parity Matrix
        H=[eye(n-k,n-k);P]'//Parity Check Matrix
        //disp(H,'Parity Check Matrix H') //for testing

if SynPolyCoeff==[0 0 0]  then //[0 0 0] indicates no error
    disp(R,'Recieved Code without error')
    disp(R(4:7),'Recieved Information Message')//Extract and display  Message from code word
else 
    //Find erroneous bit position
    //Here we find colomn within H matrix with pattern simmilar to Syndrome Matrix
    //The position number of that colomn is equivalent to erroneous bit position
    
    ErrPos=1//Initiallize erroneous bit position
    d=[H(:,ErrPos)]'//Transpose of first coloumn of H matrix 
                    //(Transpose is used to convert colomn to row as syndrome is in row format)
               
        while ((d(1)<>SynPolyCoeff(1))|(d(2)<>SynPolyCoeff(2))|(d(3)<>SynPolyCoeff(3))) do //Check element wise inequallity for any element (OR condition)
            ErrPos=ErrPos+1//Increament erroneous bit position (Point to next colomn)
            d=[H(:,ErrPos)]'//Transpose of next coloumn of H matrix
        end
    
        disp(ErrPos,'Erroneous Bit Position')
    
        //Error correction
        if R(ErrPos)==0 then
            R(ErrPos)=1//Invert bit at Erroneous Bit Position
        else
            R(ErrPos)=0//Invert bit at Erroneous Bit Position
        end
        disp(R,'Recieved Code with error corrected')
        disp(R(4:7),'Recieved Information Message')//Extract and display  Message from code word
end
disp(M,'Information Message M that was sent...')
